/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.model.kopfupcompiler.BooleanExpressionNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

public abstract class NodePatternMatcher {
    private BooleanExpressionNode fTemplateStartNode;
    private String fPatternName = "Pattern";
    private Hashtable fMatchedNodes = new Hashtable();
    private Hashtable fMatchingInfos = new Hashtable();

    public NodePatternMatcher() {
    }

    public NodePatternMatcher(String name) {
        this();
        this.fPatternName = name;
    }

    public boolean compareNodesBackwards(BooleanExpressionNode toCompareNode, BooleanExpressionNode templateNode) {
        NodeMatchingInfo matchingInfo = (NodeMatchingInfo)this.fMatchingInfos.get(templateNode);
        if (!(toCompareNode.getParentCount() == templateNode.getParentCount() || matchingInfo != null && matchingInfo.fParentCountDoesntMatter)) {
            return false;
        }
        if (this.fMatchedNodes.containsKey(templateNode)) {
            return this.fMatchedNodes.get(templateNode) == toCompareNode;
        }
        if ((matchingInfo != null && !matchingInfo.getMatchAnyType() || matchingInfo == null) && !toCompareNode.isSameType(templateNode)) {
            return false;
        }
        if (templateNode.getChildCount() == 0) {
            this.fMatchedNodes.put(templateNode, toCompareNode);
            return true;
        }
        ArrayList templateChildren = new ArrayList(templateNode.getChildren());
        ArrayList toCompareChildren = new ArrayList(toCompareNode.getChildren());
        BooleanExpressionNode toCompareChild = null;
        BooleanExpressionNode templateChild = null;
        while (!templateChildren.isEmpty()) {
            boolean rw = false;
            templateChild = (BooleanExpressionNode)templateChildren.get(0);
            for (int i = 0; i < toCompareChildren.size(); ++i) {
                toCompareChild = (BooleanExpressionNode)toCompareChildren.get(i);
                if (!this.compareNodesBackwards(toCompareChild, templateChild)) continue;
                rw = true;
                toCompareChildren.remove(toCompareChild);
                break;
            }
            if (!rw) {
                return false;
            }
            templateChildren.remove(templateChild);
        }
        if (toCompareChildren.isEmpty()) {
            this.fMatchedNodes.put(templateNode, toCompareNode);
            return true;
        }
        return false;
    }

    protected boolean matchesPattern(BooleanExpressionNode toCompare, BooleanExpressionNode templateNode) {
        this.fMatchedNodes.clear();
        boolean rw = this.compareNodesBackwards(toCompare, templateNode);
        return rw;
    }

    public void setMatchingInfo(BooleanExpressionNode node, NodeMatchingInfo matchingInfo) {
        this.fMatchingInfos.put(node, matchingInfo);
    }

    public String getPatternName() {
        return this.fPatternName;
    }

    public void setPatternName(String patternName) {
        this.fPatternName = patternName;
    }

    public BooleanExpressionNode getCorrespondingNode(BooleanExpressionNode templateNode) {
        if (this.fMatchedNodes.containsKey(templateNode)) {
            return (BooleanExpressionNode)this.fMatchedNodes.get(templateNode);
        }
        return null;
    }

    public abstract void replacePattern(Collection var1);

    public boolean matchesPattern(BooleanExpressionNode node) {
        if (this.getTemplateStartNode() == null) {
            throw new NullPointerException("No TemplateStartNode set for compare.");
        }
        return this.matchesPattern(node, this.getTemplateStartNode());
    }

    public BooleanExpressionNode getTemplateStartNode() {
        return this.fTemplateStartNode;
    }

    public void setTemplateStartNode(BooleanExpressionNode templateStartNode) {
        this.fTemplateStartNode = templateStartNode;
    }

    public static class NodeMatchingInfo {
        private boolean fMatchAnyType;
        public boolean fParentCountDoesntMatter;

        public boolean getMatchAnyType() {
            return this.fMatchAnyType;
        }

        public void setMatchAnyType(boolean matchAnyType) {
            this.fMatchAnyType = matchAnyType;
        }

        public boolean getParentCountDoesntMatter() {
            return this.fParentCountDoesntMatter;
        }

        public void setParentCountDoesntMatter(boolean parentCountDoesntMatter) {
            this.fParentCountDoesntMatter = parentCountDoesntMatter;
        }
    }
}

